function Enemy(name, hp, mp)
{
	this.name = name;
	this.hp = hp;
	this.hpmax = hp;
	this.mp = mp;
	this.mpmax = mp;
	this.strength = 3;
	this.speed = 1;
	this.stamina = 1;
	this.magic = 1;
	this.exp = 0;
	this.coins = 0;
	this.sprite = LoadSpriteset(name + ".rss");
	this.situation = "Normal";
	this.aTime = 0;
	this.aDirection = "Battle-normal";
	this.aOldDirection = "";
	this.aFrame = 0;
	this.aColor = colors.white;
	this.aFreeze = false;
	this.ailments = new Ailments();
	this.act = false;
}

Enemy.prototype.reset = function()
{
	this.hp = this.hpmax;
	this.mp = this.mpmax;
	this.aTime = 0;
	this.aDirection = "Battle-normal";
	this.aOldDirection = "";
	this.aFrame = 0;
	this.aColor = colors.white;
	this.aFreeze = false;
	this.ailments = new Ailments();
	this.act = false;
}

/*
	Enemy sprites must have the following directions
	Battle-normal
	Battle-attack
	Battle-magic
	Battle-hurt
	Battle-weak
	Battle-wounded
	Any other enemy-specific animations
*/

Enemy.prototype.clone = function()
{
	var t = new Enemy(this.name, this.hpmax, this.mpmax);
	t.hp = this.hp;
	t.mp = this.mp;
	t.aTime = this.aTime;
	t.aDirection = this.aDirection;
	t.aOldDirection = this.aOldDirection;
	t.aFrame = 0;
	t.aFreeze = this.aFreeze;
	t.ailments = this.ailments;
	t.exp = this.exp;
	t.coins = this.coins;
	t.act = this.act;
	t.x = this.x;
	t.y = this.y;
	return t;
}

Enemy.prototype.draw = function(x, y, situation, freeze)
{
	if (situation == "Normal")
	{
		if (this.hp > this.hpmax * .25)
		{
			this.aDirection = "Battle-normal";
		}
		else if (this.hp <= this.hpmax * .25 && this.hp > 0)
		{
			this.aDirection = "Battle-weak";
		}
		else if (this.hp == 0)
		{
			this.aDirection = "Battle-wounded";
		}
	}
	if (this.aOldDirection != this.aDirection)
	{
		this.aFrame = 0;
		this.aTime = GetTime();
		this.aOldDirection = this.aDirection;
		this.aFreeze = false;
	}
	if (x == undefined && y == undefined)
	{
		x = this.x;
		y = this.y;
	}
	this.sprite.images[this.sprite.directions[StrToDir(this.aDirection, this.sprite)].frames[this.aFrame].index].blitMask(x, y, this.aColor);
	if (freeze == undefined || freeze == false)
	{
		if (this.aTime + (this.sprite.directions[StrToDir(this.aDirection, this.sprite)].frames[this.aFrame].delay * 10) <= GetTime())
		{
			this.aTime = GetTime();
			this.aFrame ++;
			if (this.aFrame >= this.sprite.directions[StrToDir(this.aDirection, this.sprite)].frames.length)
			{
				this.aFrame = 0;
			}
		}
	}
}

Enemy.prototype.turn = function()
{
	Attack(this, Game.party[0]);
	this.act = true;
}

Enemy.prototype.getAttack = function()
{
	return this.strength;
}

Enemy.prototype.getDefense = function()
{
	return this.stamina;
}

Enemy.prototype.getMDefense = function()
{
	return this.magic;
}

Enemy.prototype.getSpeed = function()
{
	return this.speed;
}

Enemy.prototype.attack = function(target)
{
	return this.getAttack() - target.getDefense();
}

Enemy.prototype.die = function()
{
	Game.battle.exp += this.exp;
	Game.battle.coins += this.coins;
	var num;
	for (var i = 0; i < Game.battle.enemy.length; i ++)
	{
		if (Game.battle.enemy[i] == this)
		{
			num = i;
		}
	}
	// Remake the enemy array
	var enemy = new Array();
	var num2 = 0;
	for (var i = 0; i < Game.battle.enemy.length; i ++)
	{
		if (i != num)
		{
			enemy[num2] = Game.battle.enemy[i].clone();
			num2 ++;
		}
	}
	Game.battle.enemy = enemy;
}

var enemies = new Object();
enemies.terrapin = new Enemy("Terrapin", 10, 0);
enemies.terrapin.exp = 1;